<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Atd
 *
 * @ORM\Table(name="atd")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\AtdRepository")
 */
class Atd
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="mise_en_cause", type="string", length=50)
     */
    private $misEnCause;

    /**
     * @var string
     *
     * @ORM\Column(name="critere_diffusion", type="string", length=50)
     */
    private $critereDiffusion;

    /**
     * @var string
     *
     * @ORM\Column(name="nom_mis_en_cause", type="string", length=100)
     */
    private $nomMisEnCause;

    /**
     * @var string
     *
     * @ORM\Column(name="montant", type="string", length=50)
     */
    private $montant;

    /**
     * @var string
     *
     * @ORM\Column(name="montantHt", type="string", length=50, nullable=true)
     */
    private $montantHt;

    /**
     * @var string
     *
     * @ORM\Column(name="reste_a_payer", type="string", length=50)
     */
    private $resteAPayer;

    /**
     * @var string
     *
     * @ORM\Column(name="reference", type="string", length=50)
     */
    private $reference;

    /**
     * @var string
     *
     * @ORM\Column(name="reference_decision", type="string", length=200, nullable=true)
     */
    private $referenceDecision;

    /**
     * @var string
     *
     * @ORM\Column(name="autorite_competente", type="string", length=100, nullable=true)
     */
    private $autoriteCompetente;

    /**
     * @var string
     *
     * @ORM\Column(name="email_autorite", type="string", length=100, nullable=true)
     */
    private $emailAutorite;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone_autorite", type="string", length=100, nullable=true)
     */
    private $telephoneAutorite;

    /**
     * @var string
     *
     * @ORM\Column(name="signataire", type="text", nullable=true)
     */
    private $signataire;
    
    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\OneToMany(targetEntity="SoummissionOffre", mappedBy="atd")
    */
    private $soumissionoffre;

    /**
     * @ORM\OneToMany(targetEntity="MouvementAtd", mappedBy="atd")
    */
    private $mouvements;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="atd")
     */
    private $documents;

    /**
     * @var string
     *
     * @ORM\Column(name="pdf", type="string", length=150, nullable=true)
     */
    private $pdf;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="atd")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime();
        $this->statut = 0 ; //0=ATD EMIS, 1 = ATD Partielement Provisionné, 2=ATD Levé
        $this->reference = 'ATD_'.$this->randomString();
        $this->critereDiffusion = 0 ; //0=Tout le monde, 1 = Notifier partenaires uniquement, 2=Aucune notification        
    }

    /*
     * Create a random string
     * @author  Cedric Rio
     * @param $length the length of the string to create
     * @return $str the string
     */
    function randomString($length = 3)
    {
        $str = "";
        //$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
        $characters = array_merge(range('A','Z'), range('0','9'));
        $max = count($characters) - 1;

        date_default_timezone_set('Africa/Douala');
        $date = date('hiy', time());

        for ($i = 0; $i < $length; $i++)
        {
            $rand = mt_rand(0, $max);
            $str .= $characters[$rand];
        }
        $codeUnique=$str.''.$date;
        return $codeUnique;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set misEnCause
     *
     * @param string $misEnCause
     *
     * @return Atd
     */
    public function setMisEnCause($misEnCause)
    {
        $this->misEnCause = $misEnCause;

        return $this;
    }

    /**
     * Get misEnCause
     *
     * @return string
     */
    public function getMisEnCause()
    {
        return $this->misEnCause;
    }

    /**
     * Set nomMisEnCause
     *
     * @param string $nomMisEnCause
     *
     * @return Atd
     */
    public function setNomMisEnCause($nomMisEnCause)
    {
        $this->nomMisEnCause = $nomMisEnCause;

        return $this;
    }

    /**
     * Get nomMisEnCause
     *
     * @return string
     */
    public function getNomMisEnCause()
    {
        return $this->nomMisEnCause;
    }

    /**
     * Set montant
     *
     * @param string $montant
     *
     * @return Atd
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return string
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return Atd
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return Atd
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Atd
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set emeteur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $emeteur
     *
     * @return Atd
     */
    public function setEmeteur(\AMLA\SqrBundle\Entity\Fournissseur $emeteur = null)
    {
        $this->emeteur = $emeteur;

        return $this;
    }

    /**
     * Get emeteur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getEmeteur()
    {
        return $this->emeteur;
    }

    /**
     * Add soumissionoffre
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre
     *
     * @return Atd
     */
    public function addSoumissionoffre(\AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre)
    {
        $this->soumissionoffre[] = $soumissionoffre;

        return $this;
    }

    /**
     * Remove soumissionoffre
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre
     */
    public function removeSoumissionoffre(\AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre)
    {
        $this->soumissionoffre->removeElement($soumissionoffre);
    }

    /**
     * Get soumissionoffre
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSoumissionoffre()
    {
        return $this->soumissionoffre;
    }

    /**
     * Add mouvement
     *
     * @param \AMLA\SqrBundle\Entity\MouvementAtd $mouvement
     *
     * @return Atd
     */
    public function addMouvement(\AMLA\SqrBundle\Entity\MouvementAtd $mouvement)
    {
        $this->mouvements[] = $mouvement;

        return $this;
    }

    /**
     * Remove mouvement
     *
     * @param \AMLA\SqrBundle\Entity\MouvementAtd $mouvement
     */
    public function removeMouvement(\AMLA\SqrBundle\Entity\MouvementAtd $mouvement)
    {
        $this->mouvements->removeElement($mouvement);
    }

    /**
     * Get mouvements
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMouvements()
    {
        return $this->mouvements;
    }

    /**
     * Add document
     *
     * @param \AMLA\SqrBundle\Entity\Document $document
     *
     * @return Atd
     */
    public function addDocument(\AMLA\SqrBundle\Entity\Document $document)
    {
        $this->documents[] = $document;

        return $this;
    }

    /**
     * Remove document
     *
     * @param \AMLA\SqrBundle\Entity\Document $document
     */
    public function removeDocument(\AMLA\SqrBundle\Entity\Document $document)
    {
        $this->documents->removeElement($document);
    }

    /**
     * Get documents
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDocuments()
    {
        return $this->documents;
    }

    /**
     * Set resteAPayer
     *
     * @param string $resteAPayer
     *
     * @return Atd
     */
    public function setResteAPayer($montant)
    {
        $this->resteAPayer = $montant;

        return $this;
    }

    /**
     * Get resteAPayer
     *
     * @return string
     */
    public function getResteAPayer()
    {
        return $this->resteAPayer;
    }

    /**
     * Set pdf
     *
     * @param string $pdf
     *
     * @return Atd
     */
    public function setPdf($pdf)
    {
        $this->pdf = $pdf;

        return $this;
    }

    /**
     * Get pdf
     *
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return Atd
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set montantHt
     *
     * @param string $montantHt
     *
     * @return Atd
     */
    public function setMontantHt($montantHt)
    {
        $this->montantHt = $montantHt;

        return $this;
    }

    /**
     * Get montantHt
     *
     * @return string
     */
    public function getMontantHt()
    {
        return $this->montantHt;
    }

    /**
     * Set critereDiffusion
     *
     * @param string $critereDiffusion
     *
     * @return Atd
     */
    public function setCritereDiffusion($critereDiffusion)
    {
        $this->critereDiffusion = $critereDiffusion;

        return $this;
    }

    /**
     * Get critereDiffusion
     *
     * @return string
     */
    public function getCritereDiffusion()
    {
        return $this->critereDiffusion;
    }

    /**
     * Set referenceDecision
     *
     * @param string $referenceDecision
     *
     * @return Atd
     */
    public function setReferenceDecision($referenceDecision)
    {
        $this->referenceDecision = $referenceDecision;

        return $this;
    }

    /**
     * Get referenceDecision
     *
     * @return string
     */
    public function getReferenceDecision()
    {
        return $this->referenceDecision;
    }

    /**
     * Set emailAutorite
     *
     * @param string $emailAutorite
     *
     * @return Atd
     */
    public function setEmailAutorite($emailAutorite)
    {
        $this->emailAutorite = $emailAutorite;

        return $this;
    }

    /**
     * Get emailAutorite
     *
     * @return string
     */
    public function getEmailAutorite()
    {
        return $this->emailAutorite;
    }

    /**
     * Set telephoneAutorite
     *
     * @param string $telephoneAutorite
     *
     * @return Atd
     */
    public function setTelephoneAutorite($telephoneAutorite)
    {
        $this->telephoneAutorite = $telephoneAutorite;

        return $this;
    }

    /**
     * Get telephoneAutorite
     *
     * @return string
     */
    public function getTelephoneAutorite()
    {
        return $this->telephoneAutorite;
    }

    /**
     * Set signataire
     *
     * @param string $signataire
     *
     * @return Atd
     */
    public function setSignataire($signataire)
    {
        $this->signataire = $signataire;

        return $this;
    }

    /**
     * Get signataire
     *
     * @return string
     */
    public function getSignataire()
    {
        return $this->signataire;
    }

    /**
     * Set autoriteCompetente
     *
     * @param string $autoriteCompetente
     *
     * @return Atd
     */
    public function setAutoriteCompetente($autoriteCompetente)
    {
        $this->autoriteCompetente = $autoriteCompetente;

        return $this;
    }

    /**
     * Get autoriteCompetente
     *
     * @return string
     */
    public function getAutoriteCompetente()
    {
        return $this->autoriteCompetente;
    }
}
